#include "ringset_control.h"

/*
 * ringset_control_set_initial_condition_single_output_from_IC_parameter
 *
 * This function will take the value of the IC parameter and write it to
 *	the output bus. 
 *
 * This function assumes that the setup routine called ringset_control_assign_default_pointers, so the function
 *	ringset_control_set_initial_condition should not. 
 */
SMX_DLL_ERROR ringset_control_set_initial_condition_single_output_from_IC_parameter(
	p_smx_dll_simulation_context context_p
	,
	p_smx_dll_device device_p
){

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	s_smx_dll_bus_conversion
		conversion;

	p_ringset_control_default_pointers
		default_pointers_p = NULL;

	// cast unmanaged user storage
	default_pointers_p = (p_ringset_control_default_pointers)device_p->unmanaged_user_storage;

	// bus conversion type
	conversion.type = SMX_DLL_TYPE_8BIT;

	// bus conversion encoding
	conversion.encoding = SMX_DLL_ENCODING_UNSIGNED;

	// bus conversion value
	conversion.ubyte8 = (SMX_DLL_UBYTE8)default_pointers_p->parameter_values_p->IC;

	// write initial condition to output bus
	rv = context_p->funcs->write_bus( default_pointers_p->output_bus_pointers_p->RSET_bus_p, &( conversion ), SMX_DLL_WRITE_INITIAL_CONDITION );

	return rv;

}

/*
 * ringset_control_set_initial_condition
 *
 *	This function is declared in ringset_control.h
 */
void ringset_control_set_initial_condition(p_smx_dll_simulation_context context_p, p_smx_dll_device device_p) {

	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;

	p_ringset_control_default_pointers
		default_pointers_p = NULL;

	SMX_DLL_UINT64
		wake_identifier = RINGSET_CONTROL_PERFORM_ACTION;

#ifdef _DEBUG
//	if( IsDebuggerPresent() ) {
//		DebugBreak();
//	}
#endif

	// cast default pointers
	default_pointers_p = (p_ringset_control_default_pointers)device_p->unmanaged_user_storage;

	// set initial condition
	if( SMX_DLL_NO_ERROR != ( rv = ringset_control_set_initial_condition_single_output_from_IC_parameter( context_p, device_p ) ) ) {
		context_p->funcs->fatal_error( device_p, "Error occurred during ringset_control_set_initial_condition_single_output_from_IC_parameter." );
	}

	// request a wakeup at the wake interval
	if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->set_scheduled_wake( device_p, default_pointers_p->parameter_values_p->WAKE_INTERVAL, &( wake_identifier ) ) ) ) {
		context_p->funcs->fatal_error( device_p, "Unable to set_scheduled_wake during ringset_control_set_initial_condition." );
	}

}
