#include "counter_with_increment.h"

/*
 * counter_with_increment_action
 *
 *	This function is declared in counter_with_increment.h
 */
void counter_with_increment_action(p_smx_dll_simulation_context context_p, p_smx_dll_device device_p) {
	
	SMX_DLL_ERROR
		rv = SMX_DLL_NO_ERROR;
	
	SMX_DLL_UBYTE8
		*pending_output = NULL;

	s_smx_dll_bus_conversion
		conversion;

	p_counter_with_increment_default_pointers
		default_pointers_p = NULL;

	p_smx_dll_pin
		clock_p = NULL;

	SMX_DLL_UINT32
		bus_width = 0;

#ifdef _DEBUG
	if( IsDebuggerPresent() ) {
		DebugBreak();
	}
#endif

	// if this event is due to an input change
	if( SMX_DLL_WAKE_TYPE_INPUT_CHANGED == context_p->wake_reason.wake_type ) {

		// cast unmanaged user storage
		default_pointers_p = (p_counter_with_increment_default_pointers)device_p->unmanaged_user_storage;

		// cast user storage pointer
		pending_output = (SMX_DLL_UBYTE8*)device_p->user_storage;

		// grab a pointer to the clock pin
		if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->get_pin_by_index_from_bus( default_pointers_p->input_bus_pointers_p->CLK_bus_p, 0, &( clock_p ) ) ) ) {
			context_p->funcs->fatal_error(device_p, "Error occurred during get_pin_by_index_from_bus.");
		}

		// detect clock edge
		if( context_p->funcs->is_positive_edge( clock_p, &( rv ) ) ) {

			// prep bus conversion
			conversion.encoding = SMX_DLL_ENCODING_UNSIGNED;
			conversion.type     = SMX_DLL_TYPE_8BIT;

			// read the increment bus
			if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->read_bus( default_pointers_p->input_bus_pointers_p->INCREMENT_bus_p, &( conversion ) ) ) ) {
				context_p->funcs->fatal_error(device_p, "Error occurred during read_bus.");
			}

			// new value is pending output plus the increment
			*pending_output += conversion.ubyte8;
			
			// update conversion to write pending output to OUT bus
			conversion.ubyte8 = *pending_output;

			// write to OUT bus
			if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->write_bus( default_pointers_p->output_bus_pointers_p->OUT_bus_p, &( conversion ), 1e-9 ) ) ) {

				// check to see if we've overflowed
				if( SMX_DLL_ERROR_BUS_WRITE_OVERFLOW_POSITIVE == rv ) {

					// determine bus width
					if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->get_bus_width( default_pointers_p->output_bus_pointers_p->OUT_bus_p, &( bus_width ) ) ) ) {
						context_p->funcs->fatal_error(device_p, "Error occurred during get_bus_width.");
					}

					// adjust pending output
					*pending_output -= (SMX_DLL_UBYTE8)( pow( 2, bus_width ) );

					// update conversion to write pending output to OUT bus
					conversion.ubyte8 = *pending_output;

					// write to OUT bus
					if( SMX_DLL_NO_ERROR != ( rv = context_p->funcs->write_bus( default_pointers_p->output_bus_pointers_p->OUT_bus_p, &( conversion ), 1e-9 ) ) ) {
						context_p->funcs->fatal_error(device_p, "Error occurred during write_bus after adjustment for positive overflow.");
					}

				}

				// an error that wasn't a positive overflow has occurred
				else {
					context_p->funcs->fatal_error(device_p, "Error occurred during write_bus.");
				}

			}

		}

	}

}
